-- Migration to create the watchlist table
CREATE TABLE watchlist (
  user_id INT NOT NULL,
  performance_id INT NOT NULL,
  event_date DATETIME NOT NULL, -- Storing the specific date and time of the event from schedules
  added_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (user_id, performance_id, event_date), -- Composite key
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
  FOREIGN KEY (performance_id) REFERENCES performances(id) ON DELETE CASCADE
);

-- Optional: Index for faster lookups by user and event_date
CREATE INDEX idx_watchlist_user_event_date ON watchlist(user_id, event_date);
